class Monsterhunt2Game extends TeamGamePlus config(Monsterhunt2); //TeamGamePlus

var() bool bSpawnInTeamArea;
var() bool bScoreTeamKills;
var() config bool bNoTeamChanges;
var int	NumSupportingPlayer;
var globalconfig bool bBalanceTeams;	// bots balance teams
var globalconfig bool bPlayersBalanceTeams;	// players balance teams
var bool bBalancing;
var() config float FriendlyFireScale; //scale friendly fire damage by this value
var() config int MaxTeams; //Maximum number of teams allowed in (up to MaxAllowedTeams)
var int	MaxAllowedTeams;
var TeamInfo Teams[5]; // Red, Blue, Green, Gold, Monsters
var() config float GoalTeamScore; //like fraglimit
var() config int MaxTeamSize;
var localized string StartUpTeamMessage, TeamChangeMessage,TeamPrefix;
var localized string TeamColor[4];

var int	NextBotTeam;
var byte TEAM_Red, TEAM_Blue, TEAM_Green, TEAM_Gold;
var name CurrentOrders[4];
var int PlayerTeamNum;
var localized string StartupTeamTralier;

//replication variables:
var int Monsters, Hunters;
var int RedScore, BlueScore, GreenScore, GoldScore;

function PreBeginPlay ()
{
	Super.PreBeginPlay();

	//Spawn the mutators that are handling the sub-routines
	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'Mutator_DamageToScore'));
	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'Mutator_StatsHandler'));
}

function PostBeginPlay() 
{
local int i;
local PlayerPawn PP;


	Super(TeamGamePlus).PostBeginPlay();

	ForEach AllActors(class'PlayerPawn', PP)
		{
		PP.Health = Info_PRI(PP.PlayerReplicationInfo).HealthMax;
		}

}

function bool RestartPlayer( pawn aPlayer )	
{
	local Bot B;
	local bool bResult;

	aPlayer.DamageScaling = aPlayer.Default.DamageScaling;
	B = Bot(aPlayer);
	if ( (B != None) 
		&& (Level.NetMode != NM_Standalone) 
		&& TooManyBots() )
	{
		aPlayer.Destroy();
		return false;
	}
	bResult = Super.RestartPlayer(aPlayer);
	if ( aPlayer.IsA('TournamentPlayer') )
		{
		TournamentPlayer(aPlayer).StartSpot = LastStartSpot;
		TournamentPlayer(aPlayer).Health = Info_PRI(PlayerPawn(aPlayer).PlayerReplicationInfo).HealthMax;
		}
	return bResult;
}

function Timer()
{
	
	Super(TeamGamePlus).Timer();

	if (bGameEnded)
		return;

	ScanMonsterAndPlayerNum();
}

//This function scans the Pawn class for Players and monsters
//and send the variables to the replication class
function ScanMonsterAndPlayerNum()
{
local Pawn P;
local Info_GRI IGRI;
local int Monsters, Hunters;

	Monsters = 0;
	Hunters = 0;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
    		{
		if (P.IsA('PlayerPawn') || P.IsA('Bot'))
			{
			Hunters++;
			}
		else if (P.IsA('ScriptedPawn'))
			{
			Monsters++;
			}
		}

	//Ship the variables to the replication class
	Info_GRI(GameReplicationInfo).Monsters = Monsters;
	Info_GRI(GameReplicationInfo).Hunters = Hunters;
}

function AddToTeam( int num, Pawn Other )
{
	local teaminfo aTeam;
	local Pawn P;
	local bool bSuccess;
	local string SkinName, FaceName;

	if ( Other != None )
	{
		aTeam = Teams[0];
		aTeam.Size++;
		Other.PlayerReplicationInfo.Team = 0;
		Other.PlayerReplicationInfo.TeamName = aTeam.TeamName;
		bSuccess = false;
		if ( Other.IsA('PlayerPawn') || Other.IsA('Bot') )
			{
			Other.PlayerReplicationInfo.TeamID = 0;
			Other.PlayerReplicationInfo.Team = 0;
			PlayerPawn(Other).ClientChangeTeam(Other.PlayerReplicationInfo.Team);
			Other.Health = Info_PRI(PlayerPawn(Other).PlayerReplicationInfo).HealthMax;
			}
		else
			{
			Other.PlayerReplicationInfo.Team = 1;
			Other.PlayerReplicationInfo.TeamID = 1;
			}
	}
}

function bool SetEndCams(string Reason)
{
	local TeamInfo BestTeam;
	local int i;
	local pawn P, Best;
	local PlayerPawn player;

	// find individual winner
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	// find winner
	Info_GRI(GameReplicationInfo).Teams[0].Score = 999;
	Info_GRI(GameReplicationInfo).Teams[1].Score = 0;
	Info_GRI(GameReplicationInfo).Teams[2].Score = 0;
	Info_GRI(GameReplicationInfo).Teams[3].Score = 0;

	BestTeam = Info_GRI(GameReplicationInfo).Teams[0];
	for ( i=1; i<MaxTeams; i++ )
		if ( Info_GRI(GameReplicationInfo).Teams[i].Score > BestTeam.Score )
			BestTeam = Teams[i];

	for ( i=0; i<MaxTeams; i++ )
		if ( (BestTeam.TeamIndex != i) && (BestTeam.Score == Info_GRI(GameReplicationInfo).Teams[i].Score) )
		{
			BroadcastLocalizedMessage( DMMessageClass, 0 );
			return false;
		}		

	GameReplicationInfo.GameEndedComments = TeamPrefix@BestTeam.TeamName@GameEndedMessage;

	EndTime = Level.TimeSeconds + 3.0;
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		player = PlayerPawn(P);
		if ( Player != None )
		{
			if (!bTutorialGame)
				PlayWinMessage(Player, (Player.PlayerReplicationInfo.Team == BestTeam.TeamIndex));
			player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
	CalcEndStats();
	return true;
}


defaultproperties
{
     bScoreTeamKills=True
     MaxTeams=2
     MaxAllowedTeams=4
     MaxTeamSize=16
     TeamColor(0)="Red Hunters"
     TeamColor(1)="Blue Hunters"
     TeamColor(2)="Green Hunters"
     TeamColor(3)="Gold Hunters"
     TEAM_Blue=1
     TEAM_Green=2
     TEAM_Gold=3
     CurrentOrders(0)=Defend
     CurrentOrders(1)=Defend
     CurrentOrders(2)=Defend
     CurrentOrders(3)=Defend
     GoalTeamScore=0.000000
     bForceRespawn=True
     StartUpMessage="Hunt down all the monsters!"
     InitialBots=0
     bNoMonsters=False
     bCoopWeaponMode=True
     HUDType=Class'MonsterHUD'
     ScoreBoardType=Class'MonsterSB'
     MapListType=Class'Monsterhunt2Maplist'
     MapPrefix="MH2"
     BeaconName="MH2"
     GameName="Monsterhunt 2"
     MutatorClass=Class'Mutator_BaseMutator'
     GameReplicationInfoClass=Class'Info_GRI'
     bLocalLog=False
}
